
' .ApplicationSource Actalk-Debugging(4.1m)'!
'From VisualWorks(R) Release 2.0 of 4 August 1994 on 20 October 1995 at 1:35:39 pm'!



'- sources of Actalk-Debugging(4.1m) -'!

Address subclass: #DebugAddress
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Debug'!
DebugAddress comment:
'Cf. DebugActor comment.'!


!DebugAddress methodsFor: 'message passing'!

asynchronousSend: aMessage inMessageQueue: queue 
	"neuhaus: 25 July 1995 
	- code from Basic2Address asynchronousSend:inMessageQueue 
	- super asynchronousSend:inMessageQueue: -> inlined from Basic1Address 
	asynchronousSend:inMessageQueue: 
	- DebugMessage from Briot 
	"
	"Add the triggering of generic event after receiving a message."
	"Note that the method kernelEventReceive: will also be defined in class 
	UndefinedObject 
	so that if there is no behavior yet (for instance in case of FutureActors) nil does 
	not signal an error."
	"neuhaus: thisContext is reached from the original sender by class 
	Basic1Address through methods: doesNotUnderstand, receiveMessage, 
	receiveMessage:withType:... and so on. Thus the original sender is 
	thisContext's sender's ... sender. We look at the receiver of the sending 
	context (i.e. at the class of context): if it is a Basic1Address we are still in the 
	message passing machinery; if it is not we found the first context in the 
	message passing machinery, its sending context is the one that sent the actalk 
	message."

DebugActor debuggingIsOn ifTrue: 
	[| aContext |
	aContext := thisContext.
	[aContext sender receiver isKindOf: Basic1Address]
		whileTrue: [aContext := aContext sender].
	(aMessage isKindOf: DebugMessage)
		ifTrue: ["do not destroy specialized message types. just add the sending 
			context."
			queue nextPut: (aMessage sender: aContext sender copy)]
		ifFalse: [queue nextPut: (DebugMessage
					selector: aMessage selector
					arguments: aMessage arguments
					sender: aContext sender copy)].
	activity kernelEventReceive: aMessage]
 ifFalse: [super asynchronousSend: aMessage inMessageQueue: queue.].! !



!Context methodsFor: 'actalk debugging'!

getFirstArgument
	^stack at: 1! !



!Debugger methodsFor: 'context list'!

contextList
	"Answer the list of contexts to be viewable by the debugger list view."
	"neuhaus: 25 July 1995 
	Context stackOfSize: -> contextList 
	code from visual.sources in following comment 
	"
	"
	| ctx stk | 
	stk := OrderedCollection new: (shortStack isNil ifTrue: [100] ifFalse: 
	[shortStack]). 
	stk addLast: (ctx := processHandle topContext). 
	[(ctx := ctx sender) notNil and: [shortStack == nil or: [stk size < shortStack]]] 
	whileTrue: 
	[stk addLast: ctx]. 
	ctx == nil ifTrue: [shortStack := nil]. 
	^stk
	"

	| ctx stk |
	stk := OrderedCollection new: (shortStack isNil
					ifTrue: [100]
					ifFalse: [shortStack]).
	stk addLast: (ctx := processHandle topContext).
	[(ctx := ctx sender) notNil and: [shortStack == nil or: [stk size < shortStack]]]
		whileTrue: 
			[(DebugActor debuggingIsOn) ifTrue: [((ctx receiver isKindOf: ActiveObject)
					and: [ctx method == (Object compiledMethodAt: #performMessage:)])
					ifTrue: 
						["get the actalk message to be performed"
						| m |
						m := ctx getFirstArgument.
						(m isKindOf: DebugMessage)
							ifTrue: ["insert the actalk message's sending context"
								ctx := m sender]
							ifFalse: [ctx halt]]].
			stk addLast: ctx].
	ctx == nil ifTrue: [shortStack := nil].
	^stk! !



Message subclass: #DebugMessage
	instanceVariableNames: 'sender '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Debug'!
DebugMessage comment:
'Cf. DebugActor comment.'!


!DebugMessage methodsFor: 'accessing'!

sender
	^sender!

sender: aContext

	"neuhaus: 25 July 1995
			_ -> :=
	"

	sender := aContext! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!


!DebugMessage class methodsFor: 'creation'!

selector: aSymbol arguments: anArray sender: aContext
	"Answer an instance of me with selector, aSymbol, and arguments,
	anArray and sender a context."

	^self new setSelector: aSymbol arguments: anArray; sender: aContext! !



Activity subclass: #DebugActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Debug'!
DebugActivity comment:
'Cf. DebugActor comment.'!


!DebugActivity methodsFor: 'default classes'!

addressClass

	"neuhaus: 25 July 1995"

	^DebugAddress! !

!DebugActivity methodsFor: 'compatibility constraints'!

addressConstraint
	"neuhaus: 25 July 1995"

	"Enforce assumption of method addressClass"

	^DebugAddress! !



ActiveObject subclass: #DebugActor
	instanceVariableNames: ''
	classVariableNames: 'Debugging '
	poolDictionaries: ''
	category: 'Actalk-Debug'!
DebugActor comment:
'This class adds a debugging facility to the Actalk implementation. It is entirely 
based on sources provided by Jean-Pierre Briot for earlier versions of Actalk 
(version 3.04) and Smalltalk (Visual Works 2.0).

Addaptation by Peter Neuhaus <neuhaus@coling.uni-freiburg.de>, Freiburg University.
 
To use the debugger, subclasses of class ActiveObject should be redefined to be 
subclasses of class DebugActor, subclasses of Activity to DebugActivity, Address to
DebugAddress, and Message to DebugMessage. The debugging is turned off by default 
and can be toggled on/off DebugActor class method toggleDebugging.

Class Variables:
	Debugging - <aBoolean> true iff debugging is on

ToDo:

	There sometimes is not enough stack offered in the debugger though all context
	chaining information is present. The effect is probably due to a problem in 
	Debugger method contextList.'!


!DebugActor methodsFor: 'default classes'!

activityClass
	"neuhaus: 25 July 1995"

	^DebugActivity! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!


!DebugActor class methodsFor: 'class initialization'!

initialize
	Debugging := false! !

!DebugActor class methodsFor: 'accessing'!

debuggingIsOn
	"If debugging is on, context information will be added to all actalk message 
	sends."

	^Debugging!

toggleDebugging
	"DebugActor toggleDebugging"

	Debugging := Debugging not.
	Debugging
		ifTrue: [Transcript cr; show: 'Debugging is turned on!!'; cr]
		ifFalse: [Transcript cr; show: 'Debugging is turned off!!'; cr]! !

DebugActor initialize!


