ImplicitReplyObject subclass: #ExplicitAcceptObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Accept'!
ExplicitAcceptObject comment:
'Class ExplicitAcceptObject defines active objects behaviors with explicit acceptance of messages.

The behavior may explicitly specify within a method body that it is looking for a certain set of messages to accept.
Method answer: accepts a message matching among a set (array) of selectors.
(It is named answer: as in the POOL language, see category Actalk-Ext-Pool).
Note that construct answer: is equivalent to construct waitFor:andDo: from class AbclObject except that it simply performs the standard method associated to the message (selector) accepted.

Method answer is blocking (until it found a matching message).
Method unBlockingAnswer: is not.

Note that method answer: returns the value of the computation of the message. Method unBlockingAnswer: return true or false whether some matching message has been found and accepted.

Class ExplicitAcceptObject is defined as a subclass of class ImplicitReplyObject in order to inherit (convenient) implicit reply of messages.'!


!ExplicitAcceptObject methodsFor: 'answer constructs'!

answer: arrayOfSelectors
	"Accept and answer to some specific pattern of message (among the array of selectors).
	Wait until it can find one and return the value."

	^self activity answer: arrayOfSelectors!

unBlockingAnswer: arrayOfSelectors
	"Accept and answer to some specific pattern of message (among the array of selectors).
	As opposed to method answer: which is blocking, unBlockingAnswer: is not.
	If some matching message is found, accept it and return true.
	Otherwise return false."

	"Warning: be cautious when using unblocking answer statements
	within an endless body loop.
	The process may keep the Processor almost undefinitely.
	You have to insert 'Processor yield' statements or use the time slicing facility."

	^self activity unBlockingAnswer: arrayOfSelectors! !

!ExplicitAcceptObject methodsFor: 'default classes'!

activityClass
	"ExplicitAcceptObject user construct method(s)
		answer (and unBlockingAnswer)
			call(s)
	ExplicitAcceptActivity methods
		answer (and unBlockingAnswer)."

	^ExplicitAcceptActivity! !

!ExplicitAcceptObject methodsFor: 'compatibility constraints'!

activityConstraint
	"Enforce constraint defined by method activityClass."

	^ExplicitAcceptActivity! !

ImplicitReplyActivity subclass: #ExplicitAcceptActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Accept'!
ExplicitAcceptActivity comment:
'Class ExplicitAcceptActivity implements explicit acceptance of messages.
See behavior class ExplicitAcceptObject protocols and comment for the associated programming constructs.

Class ExplicitAcceptActivity is defined as a subclass of class ImplicitReplyActivity in order to inherit (convenient) implicit reply of messages.'!


!ExplicitAcceptActivity methodsFor: 'message handling'!

answer: arrayOfSelectors
	"Look into the mailbox for the first message matching one of the selectors,
	and then accept it.
	It is blocking and suspends until it finds any matching message.
	(This means it suspends onto incoming messages as long as necessary).
	Return the value of the computation."

	^self acceptMessage:
		(self mailBox firstMessageWithCondition: [:message |
			arrayOfSelectors includes: message selector])!

unBlockingAnswer: arrayOfSelectors
	"Look into the mailbox for the first message matching one of the selectors,
	and then accept it.
	As opposed to method answer: which is blocking, unBlockingAnswer: is not.
	If a matching message is found, accept it and return true.
	Otherwise return false."

	"Warning: be cautious when using unblocking answer statements
	within an endless body loop.
	The process may keep the Processor almost undefinitely.
	You have to insert 'Processor yield' statements or use the time slicing facility."

	| message |
	message := self mailBox checkFirstMessageWithCondition: [:msg |
		arrayOfSelectors includes: msg selector].
	^message isNil
		ifTrue:
			[false]
		ifFalse:
			[self acceptMessage: message.
			true]! !
