ActorObject subclass: #ReplaceBinaryAdder
	instanceVariableNames: 'r '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Actor-JoinCont'!
ReplaceBinaryAdder comment:
'Class ReplaceBinaryAdder represents a join continuation which adds two values along the behavior replacement model (class ActorObject).
Its replacement behavior is an instance of ReplaceUnaryAdder which stores the first value received.
We assume that the operation (+) is commutative.

Instance Variables:

	r	<Address>	the reply destination to which the computed result has to be sent.'!


!ReplaceBinaryAdder methodsFor: 'initialize'!

r: aReplyDestination
	r := aReplyDestination! !

!ReplaceBinaryAdder methodsFor: 'script'!

reply: v
	self replace: (ReplaceUnaryAdder new v1: v r: r)! !

ActorObject subclass: #ReplaceUnaryAdder
	instanceVariableNames: 'v1 r '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Actor-JoinCont'!
ReplaceUnaryAdder comment:
'Class ReplaceUnaryAdder represents a join continuation which has already received one value.
When receiving the (second) value, it performs summation and replies the result to the reply destination.
We assume that the operation (+) is commutative.

Instance Variables:

	v1	<Integer>	the first value received.
	r	<Address>	the reply destination to which the computed result has to be sent.'!


!ReplaceUnaryAdder methodsFor: 'initialize'!

v1: aValue r: aReplyDestination
	v1 := aValue.
	r := aReplyDestination! !

!ReplaceUnaryAdder methodsFor: 'script'!

reply: v
	"Note that there is no replacement behavior as computation is complete."

	r reply: v1 + v! !
