ExplicitAcceptObject subclass: #ObjectBodyObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Body'!
ObjectBodyObject comment:
'Class ObjectBodyObject is a behavior class that dispatches onto the activity class ObjectBodyActivity and ensures that the body is defined by the programmer in the application behavior subclass.

Class ObjectBodyObject is defined as a subclass of behavior class ExplicitAcceptObject because it usually needs to specify explicit acceptance of messages as it is the only way for it to receive messages.
(Meanwhile, see class PoolPhilosopher in category Actalk-Ext-Pool-Examples, as an example of body-based active object which does not receive/accept any message).'!


!ObjectBodyObject methodsFor: 'body'!

body
	"Specification of the body should be fullfilled by the application class."

	self subclassResponsibility! !

!ObjectBodyObject methodsFor: 'default classes'!

activityClass
	"This active object behavior class only purpose is to dispatch onto that activity class
	and to ensure that the body is defined by the active object behavior."

	^ObjectBodyActivity! !

ExplicitAcceptActivity subclass: #ObjectBodyActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Body'!
ObjectBodyActivity comment:
'Class ObjectBodyActivity is a class of activity which delegates the specification of the body to the behavior itself.
The body is a live routine where the active object explicitly specifies which sequence of which set of messages it is willing to explicitly accept. Computation of the body starts as soon as the object is created.
Note that basic kernel activity class Basic1Activity defines the default body as an infinite loop accepting next message in order to express default semantics of reactivity (that is implicit acceptance of messages).

Delegating the specification of the body to the behavior itself happens to be useful if the body has many references to the behavior instance variables. This may be the case with plain use of the body concept as in the OOCP languages POOL and ConcurrentEiffel (where it is named live routine).
If the body is only used to express conditions of acceptance of messages, as for the bounded buffer example, its specification may remain within the activity in order to ensure a better separation between program (the behavior) and its control/synchronization (the activity).

Class ObjectBodyActivity is defined as a subclass of class ExplicitAcceptActivity because it usually needs to specify explicit acceptance of messages as it is the only way for it to receive messages.'!


!ObjectBodyActivity methodsFor: 'activity setting'!

body
	"Delegate the specification of the body to the active object.
	This allows the active object to directly define the body."

	bself body! !

ExplicitAcceptObject subclass: #SimulatedBodyObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Body'!
SimulatedBodyObject comment:
'Class SimulatedBodyObject is a behavior class whose only purpose is to demonstrate that reactive objects (kernel active objects are activated only by message passing and accept messages implicitly) and autonomous body (autonomous live routine whose computation starts once the object is created and specifies explicit acceptance of messages) may simulate each other.

Actually, simulation of reactivity by a body is achieved within basic kernel activity class Basic1Activity which defines the default body as an infinite loop accepting next message.
Behavior class SimulatedBodyObject resimulates the body on top of reactivity by defining a body method at the behavior level. This message is automatically sent to the active object (address) once the activity (message active) is started.
As a result this initial body message will be the first and only message to be implicitly accepted, as next ones will be explicitly accepted from within the body specification.

Class SimulatedBodyObject is defined as a subclass of behavior class ExplicitAcceptObject.

Note that although behavior classes SimulatedBodyObject and ObjectBodyObject look similar in that they both define a default body at the behavior level, their semantics is different.
The body method of class ObjectBodyObject is called by the body method of class ObjectBodyActivity which redefines kernel activity parameter method body.
The body method of class SimulatedBodyObject is called by message passing. The kernel activity parameter method body has not been redefined. Thus there are two distinct levels of body methods as for a resimulation.'!


!SimulatedBodyObject methodsFor: 'activity creation'!

active
	"Send the message body to the newly created active object address."
	"Return the new active object (yourself)."

	^super active
		body;
		yourself! !

!SimulatedBodyObject methodsFor: 'script'!

body
	"Specification of the body should be fullfilled by the application class."

	self subclassResponsibility! !

