ImplicitReplyObject subclass: #IRFibonacci
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-ImplicitReply-Ex'!
IRFibonacci comment:
'Class IRFibonacci implements fibonacci computation with implicit replies.

There is no need for explicit reply destinations. Two new active objects are created to compute the two recursive sub computations. Both replies are future objects which are summed up.

If the value of the receiver of the + operation is not computed yet, + implicitly waits for the assignment of the future (see class Future). But if the receiver is computed but the argument is not computed yet, + operation will fail (because it expects a numeric argument, not a future). Meanwhile, such a failure exchanges argument with receiver and retries to perform the operation. So eventually the addition is to be completed correcttly without failure.'!


!IRFibonacci methodsFor: 'script'!

n: n
	"Create recursively two new active objects to handle the two recursive sub computations.
	Send two future type messages and sum up their values."

	^n < 2
		ifTrue:
			[1]
		ifFalse:
			[(self class new active n: n-1) + (self class new active n: n-2)]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

IRFibonacci class
	instanceVariableNames: ''!


!IRFibonacci class methodsFor: 'example'!

example
	"self example"

	^(self new active n: 10) value! !

Counter subclass: #IRCounter
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-ImplicitReply-Ex'!
IRCounter comment:
'Class IRCounter is an implicit reply version (and subclass) of the class Counter.
Consultation of the contents is now defined as in standard Smalltalk-80.'!


!IRCounter methodsFor: 'script'!

contents
	"Value is directly replied to the sender as in standard Smalltalk-80
	(via the implicit future object / reply destination)."

	^contents! !

!IRCounter methodsFor: 'default classes'!

activityClass
	^ImplicitReplyActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

IRCounter class
	instanceVariableNames: ''!


!IRCounter class methodsFor: 'example'!

example
	"self example"

	^((self new contents: 100) active
				incr;
				incr;
				contents) value! !

IRCounter subclass: #OIRCounter
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-ImplicitReply-Ex'!
OIRCounter comment:
'Class OIRCounter shows a simple check/example of optimized implicit reply active object which does not create a future object for an optimized asynchronous message send.'!


!OIRCounter methodsFor: 'script'!

Aincr
	self incr! !

!OIRCounter methodsFor: 'default classes'!

activityClass
	^OptimizedImplicitReplyActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

OIRCounter class
	instanceVariableNames: ''!


!OIRCounter class methodsFor: 'example'!

example
	"self example inspect"

	"No future object is created and returned when sending the message Aincr.
	That is, as for default, the address of the counter object is returned as the value of the message send expression."

	^(self new contents: 100) active Aincr!

example2
	"self example2 inspect"

	"A future object is created and returned when sending the message contents."

	^(self new contents: 100) active
				Aincr;
				contents! !

ImplicitReplyObject subclass: #IRMultiplyInRange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-ImplicitReply-Ex'!
IRMultiplyInRange comment:
'Class IRMultiplyInRange is a version of MultiplyInRange (concurrent computation of factorial) with implicit reply.'!


!IRMultiplyInRange methodsFor: 'script'!

from: n to: p
	"Multiplies all integers within interval [n  p] by partitioning the interval in two,
	requesting two recursive computations, and summing up the (future objects) results."

	| mid |
	^n = p
		ifTrue:
			[n]
		ifFalse:
			[mid := (n+p)//2.
			(self class new active from: n to: mid)
			* (self class new active from: mid+1 to: p)]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

IRMultiplyInRange class
	instanceVariableNames: ''!


!IRMultiplyInRange class methodsFor: 'example'!

example
	"self example"

	^(self new active from: 1 to: 10) value! !
