Activity subclass: #SmalltalkActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Smalltalk'!
SmalltalkActivity comment:
'Class SmalltalkActivity simulates standard Smalltalk-80 objects by not creating any unneeded autonomous process.'!


!SmalltalkActivity methodsFor: 'activity setting'!

start
	"No activity autonomous process."! !

ActiveObject subclass: #SmalltalkCounter
	instanceVariableNames: 'contents '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Smalltalk'!
SmalltalkCounter comment:
'Class SmalltalkCounter is an example of resimulation of a standard Smalltalk-80 object in Actalk.'!


!SmalltalkCounter methodsFor: 'initialize'!

contents: anInteger
	contents := anInteger! !

!SmalltalkCounter methodsFor: 'script'!

contents
	^contents!

incr
	contents := contents + 1!

reset
	contents := 0! !

!SmalltalkCounter methodsFor: 'default classes'!

activityClass
	^SmalltalkActivity!

addressClass
	^SmalltalkAddress! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SmalltalkCounter class
	instanceVariableNames: ''!


!SmalltalkCounter class methodsFor: 'example'!

example
	"self example"

	^(self new contents: 100) active
		incr;
		incr;
		contents! !

Address subclass: #SmalltalkAddress
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-Smalltalk'!
SmalltalkAddress comment:
'Class SmalltalkAddress simulates standard Smalltalk-80 objects by delegating the received message to the activity to perform it (which delegates in turn to the behavior). Replies (^) are used to return the return value of the method to the sender.'!


!SmalltalkAddress methodsFor: 'message passing'!

receiveMessage: aMessage
	"Delegate the message to the activity to perform it and return the value."

	^activity performMessage: aMessage! !

