GenericSendAddress subclass: #WithSenderAddress
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-WithSender'!
WithSenderAddress comment:
'Address class WithSenderAddress assigns the sender of the message into the invocation.
It also triggers the generic event method send of the sender.
Default send event method does nothing.
Class AddressClass is defined as a subclass of address class GenericSendAddress.'!


!WithSenderAddress methodsFor: 'message passing'!

receiveMessage: aMessage
	"Receive an extended invocation with the sender object address (reference).
	Before that, trigger the generic event for the sender to send a message."

	| sender |
	sender := thisContext sender sender homeReceiver address.
	sender isNil ifFalse:
		[sender asObject eventSend: aMessage to: self].
	^self receiveGenericMessage:
		((activity invocationClassFor: aMessage) new
				setSelector: aMessage selector arguments: aMessage arguments;
				sender: sender)! !

!WithSenderAddress methodsFor: 'compatibility constraints'!

activityConstraint
	"WithSenderAddress method
		receiveMessage:
			assumes that the activity returns an invocation instance of class WithSenderInvocation
			(at least having one slot for sender)
			as defined by activity class
	WithSenderActivity."

	^WithSenderActivity! !

CurrentMessageActivity subclass: #WithSenderActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-WithSender'!
WithSenderActivity comment:
'Activity class WithSenderActivity is defined to return invocation class WithSenderInvocation in order to be assigned by address class WithSenderAddress and to be used by active object behavior class WithSenderObject.
Class WithSenderActivity is defined as a subclass of class CurrentMessageActivity in order to record current message so that current sender (of current message) may be fetched.'!


!WithSenderActivity methodsFor: 'default classes'!

addressClass
	"WithSenderActivity
		is defined in order to dispatch onto invocation class WithSenderInvocation
		which should be initialized by
	WithSenderAddress method
		receiveMessage:."

	^WithSenderAddress!

invocationClassFor: aMessage
	"Invocation with one slot to record the sender of the message."

	^WithSenderInvocation! !

!WithSenderActivity methodsFor: 'compatibility constraints'!

addressConstraint
	"Ensure constraint defined by method addressClass."

	^WithSenderAddress! !

Message subclass: #WithSenderInvocation
	instanceVariableNames: 'sender '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-WithSender'!
WithSenderInvocation comment:
'Class WithSenderInvocation is a subclass of class Message.
It adds an extra instance variable (sender) to contain the sender of the message.'!


!WithSenderInvocation methodsFor: 'accessing'!

sender
	^sender!

sender: anObject
	sender := anObject! !

ActiveObject subclass: #WithSenderObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Ext-WithSender'!
WithSenderObject comment:
'Active object behavior class WithSenderObject provides access to the sender of current message.
See associated activity class WithSenderActivity.'!


!WithSenderObject methodsFor: 'sender accessing'!

sender
	"Return sender of current message."

	^self activity currentMessage sender! !

!WithSenderObject methodsFor: 'default classes'!

activityClass
	"SenderObject method
		sender
			calls
	CurrentMessageActivity method
		currentMessage
			and assumes that invocation class records sender as defined by
	WithSenderActivity method
		invocationClassFor:
			which returns class WithSenderInvocation."

	^WithSenderActivity! !

!WithSenderObject methodsFor: 'compatibility constraints'!

activityConstraint
	"Ensure constraint defined by method activityClass."

	^WithSenderActivity!

addressConstraint
	"WithSenderObject method
		sender
			assumes that the sender has been set by
	WithSenderAddress method
		receiveMessage:."

	^WithSenderAddress! !
