Address subclass: #Actor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-Compatibility'!
Actor comment:
'Class Actor simulates previous version kernel class.'!


Activity subclass: #ActorBehavior
	instanceVariableNames: 'aself '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-Compatibility'!
ActorBehavior comment:
'Class ActorBehavior simulates previous version kernel class.'!


!ActorBehavior methodsFor: 'initialize'!

initializeWithAddress: anAddress
	aself := anAddress! !

!ActorBehavior methodsFor: 'address creation'!

computeAddressClass: addressClass
	^addressClass! !

!ActorBehavior methodsFor: 'message handling'!

performMessage: aMessage
	"The activity directly perform (compute) the message."

	^self basicPerformMessage: aMessage! !

!ActorBehavior methodsFor: 'actor creation'!

actor
	"Create an actor, once the behavior is specified."
	"The class of the actor (e.g., class Actor) is specified and returned by method actorClass."
	"This is similar to method defaultControllerClass of class View."

	^self activeObject: self;
		createAddressAndStart: self actorClass!

actorClass
	"Specify the associated class of actors, by default class Actor."
	"Is redefined when defining new pairs of classes *ActorBehavior and *Actor."

	^Actor! !

!ActorBehavior methodsFor: 'events'!

eventAccept: aMessage!

eventComplete: aMessage!

eventReceive: aMessage!

kernelEventAccept: aMessage
	self eventAccept: aMessage!

kernelEventComplete: aMessage
	self eventComplete: aMessage!

kernelEventReceive: aMessage
	self eventReceive: aMessage! !

ActorBehavior subclass: #ABCounter
	instanceVariableNames: 'contents '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-Compatibility'!
ABCounter comment:
'Class ABCounter is intended as a simple check of simulated previous version kernel class ActorBehavior.'!


!ABCounter methodsFor: 'initialize'!

contents: anInteger
	contents := anInteger! !

!ABCounter methodsFor: 'script'!

consultAndReplyTo: r
	"As for asynchronous message passing, returning reply needs to be made explicit.
	The reply destination (r) is passed as an argument."

	r reply: contents!

incr
	contents := contents + 1!

reset
	contents := 0! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ABCounter class
	instanceVariableNames: ''!


!ABCounter class methodsFor: 'example'!

example
	"self example"

	(self new contents: 100) actor
				incr;
				incr;
				consultAndReplyTo: Print;
				incr;
				consultAndReplyTo: Print! !
