ActiveObject subclass: #SingleMessageActiveObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-Library'!
SingleMessageActiveObject comment:
'See class SingleMessageActivity comment.'!


!SingleMessageActiveObject methodsFor: 'default classes'!

activityClass
	"This active object behavior class only purpose is to dispatch onto this single message activity class."

	^SingleMessageActivity! !

Activity subclass: #SingleMessageActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-Library'!
SingleMessageActivity comment:
'Class SingleAcceptActivity models activities for which we MAY assume that they are going to receive (and accept) only one single message.
This class creates a process body with only one single message acceptance. This avoids creating infinite processes which will create wasted resources and are difficult to recover.
Examples of uses are many classes of continuations, like class FactorialContinuation, as well as some example classes like classes Producer and Consumer in category Actalk-Ex-BoundedBuffer.'!


!SingleMessageActivity methodsFor: 'activity setting'!

body
	"Accept a single message."

	self acceptNextMessage! !
