ActiveObject subclass: #BlockContinuation
	instanceVariableNames: 'behaviorBlock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-ReplyDest'!
BlockContinuation comment:
'Class BlockContinuation purpose is to avoid explicit creation of numerous classes of continuations because of explicit handling of replies (as examplified by class FactorialContinuation, see category Actalk-Examples).

It owns a block closure which represents the behavior of the continuation. The block must have one parameter representing the value replied to the continuation (argument of reply: message) and a second parameter representing the continuation active object itself (its address, usually named me). This latter parameter may be useful when passing reference to the continuation active object to other active objects, for recursion, and for terminating the process.

Class BlockContinuation allowes specification of various behaviors of continuations through a single behavior class.

Note that because block closures have lexical scoping, the programmer does not need to explicitly declare (closure of) variables of the continuation. (Contrast the creation of factorial continuation as a block continuation with the creation of an instance of class FactorialContinuation by comparing various methods of class Factorial). Anonymous block continuations are analog to anonymous lambda expressions for defining continuations in Scheme.

We assume that replies are conveyed by a message with selector reply:. This convention makes easy sharing and reuse of various predefined reply destination actors. See class ActiveTranscript as an example of such a widely shared reply destination.

Method named continuationBlock: of class ActiveObject provides a more concise way of specifiying a block continuation actor.

Instance Variables:

	behaviorBlock	<BlockClosure>	a block with two arguments which implements the behavior of the continuation actor.

Class SingleReplyBlockContinuation introduces an optimization of class BlockContinuation when only one reply is expected.

Acknowledgements:
Block continuations were initially introduced by Alexis Drogoul when implementing the Actalk-based eco-simulation testbed named Ecotalk.'!


!BlockContinuation methodsFor: 'accessing'!

behaviorBlock: aBlock
	"Assign the block representing the behavior of the continuation."
	"The block must have one argument which represents the replied value,
	and a second argument which represents the address of the continuation active object itself
	(useful for recursion or passing its reference along)."

	behaviorBlock := aBlock! !

!BlockContinuation methodsFor: 'script'!

reply: value
	"Behavior of the continuation when receiving a value: compute the block.
	Second argument is its address: aself, useful for recursion, passing its value, and for termination."

	behaviorBlock value: value value: aself! !

BlockContinuation subclass: #SingleReplyBlockContinuation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-ReplyDest'!
SingleReplyBlockContinuation comment:
'Class SingleReplyBlockContinuation introduces an optimization of class BlockContinuation when only one reply is expected.
It is a subclass of class BlockContinuation.
because we assume that only one reply is expected, we use a behavior process to accept only one message. This also eliminates the need for explicitly terminating the process to recover resources.

Method named singleReplyContinuationBlock: of class ActorBehavior provides a more concise way of specifiying a single reply block continuation actor. See example of use in class Factorial.'!


!SingleReplyBlockContinuation methodsFor: 'default classes'!

activityClass
	"Optimized version of BlockContinuation which is assumed to accept only one reply message."

	^SingleMessageActivity! !

ActiveObject subclass: #ActiveTranscript
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Kernel-ReplyDest'!
ActiveTranscript comment:
'Class ActiveTranscript has one predefined instance refered by global variable Print which is the active object representative of the Transcript window. Print is used to print out replies (by convention with reply message selector reply:). Print is the final reply destination of many computations (see category Actalk-Examples).'!


!ActiveTranscript methodsFor: 'script'!

reply: v
	"Print out the reply onto the Transcript window."

	Transcript show: '> ' , v printString; cr! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ActiveTranscript class
	instanceVariableNames: ''!


!ActiveTranscript class methodsFor: 'initialize'!

initialize
	"Create the predefined ActiveTranscript active object refered by global variable Print."
	"May need some reinitialization in case the Print active object has been terminated."

	"ActiveTranscript initialize"

	Smalltalk at: #Print put: self new active! !
ActiveTranscript initialize!

