GetRearConcurrentBoundedBuffer subclass: #ASCGetRear2BoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCGetRear2BoundedBuffer comment:
'This class implements an example of inheritance anomaly. Note that the gget example is not very significant in a concurrent context. This example of getRear provides possible concurrency between two get methods (get and getRear) as they access to different memory zones.
In this second version we allow one get and one getRear to be served concurrently. Therefore we need to ensure that there at least two elements in the buffer.'!


!ASCGetRear2BoundedBuffer methodsFor: 'state predicates'!

isOne
	^(putIndex - 1) = (getIndex \\ array size)! !

!ASCGetRear2BoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states and by the guards."

	^ASCGetRear2BoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ASCGetRear2BoundedBuffer class
	instanceVariableNames: ''!


!ASCGetRear2BoundedBuffer class methodsFor: 'example'!

exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio! !

ConcurrentBoundedBuffer subclass: #ASCBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCBoundedBuffer comment:
'Class ASCBoundedBuffer implements the example of the bounded buffer with:
	
	abstract states to express synchronization constraints based on the state of the bounded buffer,
	guards on synchronization counters to specify synchronization constraints on actual activation.

Note that because guard specifications are now highly modular and expressive, they behave quite well against inheritance anomaly.'!


!ASCBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states and by the guards."

	^ASCBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ASCBoundedBuffer class
	instanceVariableNames: ''!


!ASCBoundedBuffer class methodsFor: 'example'!

exampleSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleSize: maxSize numberItems: numberItems speedRatio: ratio!

fCFSExampleSize: maxSize numberItems: numberItems speedRatio: ratio
	"self fCFSExampleSize: 3 numberItems: 8 speedRatio: 3"
	"self fCFSExampleSize: 3 numberItems: 8 speedRatio: 1/3"

	| buffer producer consumer |
	buffer := (self new: maxSize) active: ASIFCFSBoundedBufferActivity.
	producer := (Producer new buffer: buffer delay: 1) active.
	consumer := (Consumer new buffer: buffer delay: ratio) active.
	producer runPut: numberItems.
	consumer runGet: numberItems! !

Get2ConcurrentBoundedBuffer subclass: #ASCGet2BoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCGet2BoundedBuffer comment:
'This class implements an example of inheritance anomaly.'!


!ASCGet2BoundedBuffer methodsFor: 'state predicates'!

isOne
	^(putIndex - 1) = (getIndex \\ array size)! !

!ASCGet2BoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states and by the guards."

	^ASCGet2BoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ASCGet2BoundedBuffer class
	instanceVariableNames: ''!


!ASCGet2BoundedBuffer class methodsFor: 'example'!

exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio! !

GetRearConcurrentBoundedBuffer subclass: #ASCGetRearBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCGetRearBoundedBuffer comment:
'This class implements an example of inheritance anomaly. Note that the gget example is not very significant in a concurrent context. This example of getRear provides possible concurrency between two get methods (get and getRear) as they access to different memory zones.
In this first version we cannot actually allow one get and one getRear to be served concurrently because there could be less than two elements in the buffer. See second version (class ASCGetRear2BoundedBuffer) for an improved specification.'!


!ASCGetRearBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states and by the guards."

	^ASCGetRearBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ASCGetRearBoundedBuffer class
	instanceVariableNames: ''!


!ASCGetRearBoundedBuffer class methodsFor: 'example'!

exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio! !

ASCActivity subclass: #ASCBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.
Note the independence of abstract states and guards which increase modularity.'!


!ASCBoundedBufferActivity methodsFor: 'abstract states'!

empty
	^#(put:)!

full
	^#(get)!

initialAbstractState
	^#empty!

partial
	"Note that we use union of sets (in fact concatenation of arrays) for better modularity.
	See class ASCGet2BoundedBufferActivity redefinition of #full,
	and consequently implicit redefinition of #partial."

	^(self empty) + (self full)! !

!ASCBoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	^bself isEmpty
		ifTrue: [#empty]
		ifFalse: [bself isFull
					ifTrue: [#full]
					ifFalse: [#partial]]! !

!ASCBoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"Only one get at once."

	^(self current: #get) = 0!

guardOFput: item
	"Only one put at once."

	^(self current: #put:) = 0! !

ASCBoundedBufferActivity subclass: #ASCGetRearBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCGetRearBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.
See the strategy described in class ASCGetRearBoundedBuffer comment.'!


!ASCGetRearBoundedBufferActivity methodsFor: 'abstract states'!

full
	^(super full) + #(getRear)! !

!ASCGetRearBoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"One more constraint: no getRear because there could be only one element."

	^super guardOFget
		and: [(self current: #getRear) = 0]!

guardOFgetRear
	"GetRear excludes all methods.
	Restrict get and getRear concurrency because there could be only one element."

	^(self current: #getRear) = 0
		and: [(self current: #get) = 0
				and: [(self current: #put:) = 0]]!

guardOFput: item
	"One more constraint: no getRear."

	^(super guardOFput: item)
		and: [(self current: #getRear) = 0]! !

ASCBoundedBufferActivity subclass: #ASCGgetBoundedBufferActivity
	instanceVariableNames: 'afterPut '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!


!ASCGgetBoundedBufferActivity methodsFor: 'initialize'!

privateInitialize
	super privateInitialize.
	afterPut := false! !

!ASCGgetBoundedBufferActivity methodsFor: 'abstract states'!

full
	^#(gget) + (super full)! !

!ASCGgetBoundedBufferActivity methodsFor: 'events'!

synchroEventComplete: aMessage
	super synchroEventComplete: aMessage.
	afterPut := aMessage selector = #put:! !

!ASCGgetBoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"One more constraint: no gget."

	^super guardOFget
		and: [(self current: #gget) = 0]!

guardOFgget
	"Not after a put and as for get."

	^afterPut not
		and: [self guardOFget]! !

ASCBoundedBufferActivity subclass: #ASCGet2BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCGet2BoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!ASCGet2BoundedBufferActivity methodsFor: 'abstract states'!

full
	^(super full) + #(get2)!

one
	^(self partial) - #(get2)

	"Note that an alternative is: ^(self empty) + #(get)."! !

!ASCGet2BoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	^bself isOne
		ifTrue: [#one]
		ifFalse: [super nextAbstractStateAfter: selector]! !

!ASCGet2BoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"One more constraint: no get2."

	^super guardOFget
		and: [(self current: #get2) = 0]!

guardOFget2
	"As for get"

	^self guardOFget! !

ASIActivity subclass: #ASIFCFSBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASIFCFSBoundedBufferActivity comment:
'Class ASIFCFSBoundedBufferActivity adds the constraint of message ordering preservation (FCFS) to the bounded buffer example.'!


!ASIFCFSBoundedBufferActivity methodsFor: 'abstract states'!

empty
	^#(put:)!

full
	^#(get)!

initialAbstractState
	^#empty!

partial
	^(self empty) + (self full)! !

!ASIFCFSBoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	^bself isEmpty
		ifTrue: [#empty]
		ifFalse: [bself isFull
					ifTrue: [#full]
					ifFalse: [#partial]]! !

!ASIFCFSBoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"Only one get at once.
	Also ensures message ordering preservation (no prior pending get)."

	^(self noCurrent: #get)
		and: [self noPending: #get priorTo: currentInvocation arrivalTime]!

guardOFput: item
	"Only one put at once.
	Also ensures message ordering preservation (no prior pending put:)."

	^(self noCurrent: #put:)
		and: [self noPending: #put: priorTo: currentInvocation arrivalTime]! !

ASCBoundedBuffer subclass: #ASCGgetBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!


!ASCGgetBoundedBuffer methodsFor: 'script'!

gget
	"Gget is like a get but should not be served after a get."
	"This constraint will be ensured by subclasses with various synchronization policies."

	^self get! !

!ASCGgetBoundedBuffer methodsFor: 'events'!

eventAccept: aMessage
	"This trace may be useful to check that gget constraint (not after a put) is enforced
	by a specific synchronization policy."

	Transcript show: self printString , ' accept (' , aMessage compactPrintString , ')'; cr!

eventComplete: aMessage
	"This trace may be useful to check that gget constraint (not after a put) is enforced
	by a specific synchronization policy."

	Transcript show: self printString , ' complete (' , aMessage compactPrintString , ')'; cr! !

!ASCGgetBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity guards specification."

	^ASCGgetBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ASCGgetBoundedBuffer class
	instanceVariableNames: ''!


!ASCGgetBoundedBuffer class methodsFor: 'example'!

exampleGget2Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGget2Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleGget2Size: 3 numberItems: 8 speedRatio: 1/3"

	"Note that there is no guarantee that all gget requests will be served.
	As a result the bounded buffer may stop before all producer and consumer requests had been served."

	| buffer producer consumer |
	buffer := (self new: maxSize) active: ASCGget2BoundedBufferActivity.
	producer := (Producer new buffer: buffer delay: 1) active.
	consumer := (Consumer new buffer: buffer delay: ratio) active.
	producer runPut: numberItems.
	consumer runGget: numberItems!

exampleGgetSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGgetSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleGgetSize: 3 numberItems: 8 speedRatio: 1/3"

	"Note that there is no guarantee that all gget requests will be served.
	As a result the bounded buffer may stop before all producer and consumer requests had been served."

	| buffer producer consumer |
	buffer := (self new: maxSize) active.
	producer := (Producer new buffer: buffer delay: 1) active.
	consumer := (Consumer new buffer: buffer delay: ratio) active.
	producer runPut: numberItems.
	consumer runGget: numberItems! !

ASCBoundedBufferActivity subclass: #ASCGetRear2BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!
ASCGetRear2BoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.
See the strategy described in class ASCGetRear2BoundedBuffer comment.'!


!ASCGetRear2BoundedBufferActivity methodsFor: 'abstract states'!

full
	^(super full) + #(getRear)!

one
	"We disallow one of the possible get requests because there is only one element,
	and consequently one get and one getRear cannot be active concurrently.
	Note that by disallowing getRear (rather than get) we give priority to get."

	^(self partial) - #(getRear)! !

!ASCGetRear2BoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	^bself isOne
		ifTrue: [#one]
		ifFalse: [super nextAbstractStateAfter: selector]! !

!ASCGetRear2BoundedBufferActivity methodsFor: 'guards'!

guardOFgetRear
	"As for put:."

	^self guardOFput: #dummy!

guardOFput: item
	"One more constraint: no getRear."

	^(super guardOFput: item)
		and: [(self current: #getRear) = 0]! !

ASCBoundedBufferActivity subclass: #ASCGget2BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC-Examples'!


!ASCGget2BoundedBufferActivity methodsFor: 'abstract states'!

partialNotAfterPut
	"Note that gget is specified first in order to provide it priority over get."

	^#(gget) + (self partial)! !

!ASCGget2BoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	"We check if the bounded buffer is in partial state (that is neither empty nor full) AND not after a put."

	^((bself isEmpty | bself isFull) not
			and: [selector ~= #put:])
		ifTrue: [#partialNotAfterPut]
		ifFalse: [super nextAbstractStateAfter: selector]! !

!ASCGget2BoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"One more constraint: no gget."

	^super guardOFget
		and: [(self current: #gget) = 0]!

guardOFgget
	"As for get."

	^self guardOFget! !

