CountersActivity subclass: #ASCActivity
	instanceVariableNames: 'enabledSelectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC'!
ASCActivity comment:
'Activity class ASCActivity implements a mixed synchronization model.
ASC stands for Abstract State and Synchronization Counters.

This means having both:
	state transitions to specify state synchronization,
	and activation conditions (guards based on synchronization counters) to specify activation synchronization.

As a result specification is more modular and reusable. However these two synchronization dimensions are not fully orthogonal. (See example of classes ASCGetRearBoundedBuffer and ASCGetRear2BoundedBuffer).

This model has been proposed by Laurent Thomas at PARLE92 Conference.

Class ASCActivity is a combination of synchronization classes AbstractStatesActivity and CountersActivity. However because there is no multiple inheritance, we choose the most complex class, CountersActivity as the superclass, and we recopy the state transition part part. Meanwhile we need to be careful about the combination, because we have to ensure atomicity of checking of conditions and method completion. (This is actually easily specified through simple refinement of method checking the guard to also include the enabling check.)

See examples within category Actalk-Synchro-ASC-Ex.'!


!ASCActivity methodsFor: 'initialize'!

privateInitialize
	"Compute and assign the initial collection of enabled selectors."

	super privateInitialize.
	enabledSelectors := self perform: self initialAbstractState! !

!ASCActivity methodsFor: 'message handling'!

evaluateGuardForMessage: aMessage
	"Evaluate the associated condition/guard with the current arguments.
	Checks if the message belongs to current set of enabled selectors
		AND if the guard evaluates to true.
	Note that both checks must be done within the same atomic block."

	^(enabledSelectors includes: aMessage selector)
		and: [super evaluateGuardForMessage: aMessage]! !

!ASCActivity methodsFor: 'synchro events'!

synchroEventComplete: aMessage
	"Compute transition to next abstract state (leading to next enabled selectors)
	after computing the message."

	super synchroEventComplete: aMessage.
	enabledSelectors := self perform: (self nextAbstractStateAfter: aMessage selector)! !

!ASCActivity methodsFor: 'abstract states'!

initialAbstractState
	"Return the initial abstract state.
	Must return some abstract state symbol/selector."
	"Mandatory. Must be supplied by the class or one of its superclass."

	^self subclassResponsibility! !

!ASCActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	"Specify and compute next abstract state.
	Must return some abstract state symbol/selector."
	"Mandatory. Must be supplied by the class or one of its superclass."

	^self subclassResponsibility! !

PlainInvocationActivity subclass: #ASIActivity
	instanceVariableNames: 'enabledSelectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-ASC'!
ASIActivity comment:
'Activity class ASIActivity implements a mixed synchronization model.
ASI stands for Abstract State, synchronization counters and Invocations.

Class ASIActivity is a combination of abstract states (class AbstractStatesActivity) and synchronization counters with generic invocations (class PlainInvocationActivity).

The definitions of classes ASCActivity and ASIActivity are actually identical, but they inherit respectively from class CountersActivity and its subclass PlainInvocationActivity.

Activity class ASIActivity currently represents the most advanced, sophisticated and expressive model for synchronization.

See examples within category Actalk-Synchro-ASC-Ex.'!


!ASIActivity methodsFor: 'initialize'!

privateInitialize
	"Compute and assign the initial collection of enabled selectors."

	super privateInitialize.
	enabledSelectors := self perform: self initialAbstractState! !

!ASIActivity methodsFor: 'message handling'!

evaluateGuardForMessage: aMessage
	"Evaluate the associated condition/guard with the current arguments.
	Checks if the message belongs to current set of enabled selectors
		AND if the guard evaluates to true.
	Note that both checks must be done within the same atomic block."

	^(enabledSelectors includes: aMessage selector)
		and: [super evaluateGuardForMessage: aMessage]! !

!ASIActivity methodsFor: 'synchro events'!

synchroEventComplete: aMessage
	"Compute transition to next abstract state (leading to next enabled selectors)
	after computing the message."

	super synchroEventComplete: aMessage.
	enabledSelectors := self perform: (self nextAbstractStateAfter: aMessage selector)! !

!ASIActivity methodsFor: 'abstract states'!

initialAbstractState
	"Return the initial abstract state.
	Must return some abstract state symbol/selector."
	"Mandatory. Must be supplied by the class or one of its superclass."

	^self subclassResponsibility! !

!ASIActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	"Specify and compute next abstract state.
	Must return some abstract state symbol/selector."
	"Mandatory. Must be supplied by the class or one of its superclass."

	^self subclassResponsibility! !

