Get2BoundedBuffer subclass: #AbstractStatesGet2BoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!
AbstractStatesGet2BoundedBuffer comment:
'This class implements an example of inheritance anomaly.'!


!AbstractStatesGet2BoundedBuffer methodsFor: 'state predicates'!

isOne
	^contents size = 1! !

!AbstractStatesGet2BoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states specification."

	^AbstractStatesGet2BoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AbstractStatesGet2BoundedBuffer class
	instanceVariableNames: ''!


!AbstractStatesGet2BoundedBuffer class methodsFor: 'example'!

exampleGet21Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGet21Size: 1 numberItems: 2 speedRatio: 3"
	"self exampleGet2Size: 1 numberItems: 2 speedRatio: 1/3"

	self exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio!

exampleGet22Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGet22Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleGet22Size: 3 numberItems: 8 speedRatio: 1/3"

	| buffer producer consumer |
	buffer := (self new: maxSize) active: AbstractStatesGet22BoundedBufferActivity.
	producer := (Producer new buffer: buffer delay: 1) active.
	consumer := (Consumer new buffer: buffer delay: ratio) active.
	producer runPut: numberItems.
	consumer runGet2: numberItems!

exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio!

exampleIsEmptyGet2Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleIsEmptyGet2Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleIsEmptyGet2Size: 3 numberItems: 8 speedRatio: 1/3"

	| buffer producer consumer |
	buffer := (self new: maxSize) active: AbstractStatesIsEmptyGet2BoundedBufferActivity.
	producer := (Producer new buffer: buffer delay: 1) active.
	consumer := (Consumer new buffer: buffer delay: ratio) active.
	producer runPut: numberItems.
	consumer runIsEmptyGet2: numberItems! !

GetRearBoundedBuffer subclass: #AbstractStatesGetRearBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!


!AbstractStatesGetRearBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states specification."

	^AbstractStatesGetRearBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AbstractStatesGetRearBoundedBuffer class
	instanceVariableNames: ''!


!AbstractStatesGetRearBoundedBuffer class methodsFor: 'example'!

exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio! !

AbstractStatesActivity subclass: #AbstractStatesBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!
AbstractStatesBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!AbstractStatesBoundedBufferActivity methodsFor: 'abstract states'!

empty
	^#(put:)!

full
	^#(get)!

initialAbstractState
	^#empty!

partial
	"Note that we use union of sets (in fact concatenation of arrays) for better modularity.
	See class AbstractStatesGet2BoundedBufferActivity redefinition of #full,
	and consequently implicit redefinition of #partial."

	^(self empty) + (self full)! !

!AbstractStatesBoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	^bself isEmpty
		ifTrue: [#empty]
		ifFalse: [bself isFull
					ifTrue: [#full]
					ifFalse: [#partial]]! !

IRBoundedBuffer subclass: #AbstractStatesBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!
AbstractStatesBoundedBuffer comment:
'Class AbstractStatesBoundedBuffer implements the bounded buffer example with abstract states to specify synchronization.
Abstract states specification and transition is expressed within the associated activity class in order to enforce a clear separation between program and control.
Note that because abstract state specifications are quite modular, they behave quite well against inheritance anomaly.'!


!AbstractStatesBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states specification."

	^AbstractStatesBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AbstractStatesBoundedBuffer class
	instanceVariableNames: ''!


!AbstractStatesBoundedBuffer class methodsFor: 'example'!

exampleSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleSize: maxSize numberItems: numberItems speedRatio: ratio! !

AbstractStatesBoundedBufferActivity subclass: #AbstractStatesGet2BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!
AbstractStatesGet2BoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!AbstractStatesGet2BoundedBufferActivity methodsFor: 'abstract states'!

full
	^(super full) + #(get2)!

one
	^(self partial) - #(get2)

	"Note that an alternative is: ^(self empty) + #(get)."!

oneAndFull
	"The case of a buffer of size 1 is full.
	This means the intersection of sets one AND full."

	^(self one) & (self full)! !

!AbstractStatesGet2BoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	^bself isOne
		ifTrue: [bself isFull
					ifTrue: [#oneAndFull]
					ifFalse: [#one]]
		ifFalse: [super nextAbstractStateAfter: selector]! !

AbstractStatesGet2BoundedBufferActivity subclass: #AbstractStatesIsEmptyGet2BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!


!AbstractStatesIsEmptyGet2BoundedBufferActivity methodsFor: 'abstract states'!

always
	"Method isEmpty is added to the interface and specified as an always enabled method."

	^#(isEmpty)! !

AbstractStatesBoundedBufferActivity subclass: #AbstractStatesGetRearBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!


!AbstractStatesGetRearBoundedBufferActivity methodsFor: 'abstract states'!

full
	^(super full) + #(getRear)! !

AbstractStatesBoundedBufferActivity subclass: #AbstractStatesGgetBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!
AbstractStatesGgetBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!AbstractStatesGgetBoundedBufferActivity methodsFor: 'abstract states'!

partialNotAfterPut
	"Note that gget is specified first in order to provide it priority over get."

	^#(gget) + (self partial)! !

!AbstractStatesGgetBoundedBufferActivity methodsFor: 'state transition'!

nextAbstractStateAfter: selector
	"We check if the bounded buffer is in partial state (that is neither empty nor full) AND not after a put."

	^((bself isEmpty | bself isFull) not
			and: [selector ~= #put:])
		ifTrue: [#partialNotAfterPut]
		ifFalse: [super nextAbstractStateAfter: selector]! !

GgetBoundedBuffer subclass: #AbstractStatesGgetBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!
AbstractStatesGgetBoundedBuffer comment:
'This class implements an example of inheritance anomaly.'!


!AbstractStatesGgetBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity abstract states specification."

	^AbstractStatesGgetBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AbstractStatesGgetBoundedBuffer class
	instanceVariableNames: ''!


!AbstractStatesGgetBoundedBuffer class methodsFor: 'example'!

exampleGgetSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGgetSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleGgetSize: 3 numberItems: 8 speedRatio: 1/3"

	"Note that there is no guarantee that all gget requests will be served.
	As a result the bounded buffer may stop before all producer and consumer requests had been served."

	super exampleGgetSize: maxSize numberItems: numberItems speedRatio: ratio! !

AbstractStatesBoundedBufferActivity subclass: #AbstractStatesGet22BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-AbsStates-Ex'!


!AbstractStatesGet22BoundedBufferActivity methodsFor: 'abstract states'!

full
	^bself isOne
		ifTrue: [super full]
		ifFalse: [(super full) + #(get2)]!

partial
	^bself isOne
		ifTrue: [super partial]
		ifFalse: [(super partial) + #(get2)]! !

