Get2ConcurrentBoundedBuffer subclass: #CountersGet2BoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
CountersGet2BoundedBuffer comment:
'This class implements an example of inheritance anomaly.'!


!CountersGet2BoundedBuffer methodsFor: 'accessing'!

maxSize
	^maxSize! !

!CountersGet2BoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity guards specification."

	^CountersGet2BoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CountersGet2BoundedBuffer class
	instanceVariableNames: ''!


!CountersGet2BoundedBuffer class methodsFor: 'example'!

exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio! !

ActiveObject subclass: #BookUser
	instanceVariableNames: 'number book numberSteps '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
BookUser comment:
'Class BookUser is defined as an abstract class to share common structure between reader and writer classes.
Class BookUser is defined as a simple subclass of class ActiveObject.

Note that it is associated with activity class ObjectBodyActivity to express its activity (as a reader or as a writer).'!


!BookUser methodsFor: 'initialize'!

number: n book: aBook numberSteps: steps
	number := n.
	book := aBook.
	numberSteps := steps! !

!BookUser methodsFor: 'private routines'!

think
	| delay |
	delay := (Random new next * 5) rounded + 1.
	Transcript show: self printString , ' thinks during ' , delay printString , ' seconds.'; cr.
	(Delay forSeconds: delay) wait! !

!BookUser methodsFor: 'printing'!

printOn: aStream
	"Print as its class name followed by its number."

	aStream nextPutAll: self class name.
	number printOn: aStream! !

!BookUser methodsFor: 'default classes'!

activityClass
	"Activity of a book reader or writer is described by its body."

	^ObjectBodyActivity! !

BookUser subclass: #Writer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
Writer comment:
'Class Writer simply defines its body to do numberSteps time writes. Random delays are used to simulate various interleavings between readers and writers.
Class Writer is defined as a subclass of abstract class BookUser.

This class has been initially designed and implemented in a previous version of Actalk by a group of students of DESS of University of Nantes, under the guidance of Jean Bezivin and Olivier Roux.'!


!Writer methodsFor: 'body'!

body
	"Body: do numberSteps times his life steps, that is: think and then write."
	"Note that this active object class has no script method as it receives no message."

	numberSteps timesRepeat: 
		[self think.
		Transcript show: self printString , ' wants to write ' , book printString; cr.
		(book writeBy: aself) value]! !

CountersActivity subclass: #CountersBoundedBufferActivity
	instanceVariableNames: 'maxSize '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
CountersBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!CountersBoundedBufferActivity methodsFor: 'initialize'!

privateInitialize
	super privateInitialize.
	maxSize := bself maxSize! !

!CountersBoundedBufferActivity methodsFor: 'accessing'!

numberOfElements
	"Number of elements currently in the buffer.
	Compute the difference between completed put: and completed get.
	Note: this is correct because we assume that there is only one put: at once, and only one get at once."
	"Note: this method is useful as a shortcut within guards.
	But moreover this abstract method will be useful to maintain consistency when counting
	elements in the buffer regardless of how many new get methods are defined in subclasses.
	Otherwise we would have to possibly redefine ALL guards."

	^(self completed: #put:) - (self completed: #get)! !

!CountersBoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"Only one get at once and the buffer should be not empty."

	^(self current: #get) = 0
		and: [self numberOfElements > 0]!

guardOFput: item
	"Only one put at once and the buffer should not be full."

	^(self current: #put:) = 0
		and: [self numberOfElements < maxSize]! !

GetRearConcurrentBoundedBuffer subclass: #CountersGetRearBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
CountersGetRearBoundedBuffer comment:
'This class implements an example of inheritance anomaly. Note that the gget example is not very significant in a concurrent context. This example of getRear provides possible concurrency between two get methods (get and getRear) as they access to different memory zones.'!


!CountersGetRearBoundedBuffer methodsFor: 'accessing'!

maxSize
	^maxSize! !

!CountersGetRearBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity guards specification."

	^CountersGetRearBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CountersGetRearBoundedBuffer class
	instanceVariableNames: ''!


!CountersGetRearBoundedBuffer class methodsFor: 'example'!

exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleGetRearSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleGetRearSize: maxSize numberItems: numberItems speedRatio: ratio! !

CountersActivity subclass: #BookActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
BookActivity comment:
'Class BookActivity specifies the basic synchronization of the readers and writers problem, that is:

	multiple concurrent readers are allowed,
	and
	only one writer at a time is allowed in exclusion with any other (reader or writer).'!


!BookActivity methodsFor: 'guards'!

guardOFreadBy: reader
	"No writer allowed. But concurrent readers are allowed."

	^(self current: #writeBy:) = 0!

guardOFstart
	"Free start."

	^true!

guardOFwriteBy: writer
	"Only one writer and no reader."

	^((self current: #writeBy:) = 0)
		and: [(self current: #readBy:) = 0]! !

BookActivity subclass: #ReaderPriorityBookActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
ReaderPriorityBookActivity comment:
'Class ReaderPriorityBookActivity specifies priority to the readers, that is no write if there is a pending read.
Class ReaderPriorityBookActivity is defined as a subclass of activity class BookActivity.'!


!ReaderPriorityBookActivity methodsFor: 'guards'!

guardOFwriteBy: writer
	"Priority to readers, that is no write if there is a pending read."

	^(super guardOFwriteBy: writer)
		and: [(self pending: #readBy:) = 0]! !

CountersBoundedBufferActivity subclass: #CountersGet2BoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
CountersGet2BoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!CountersGet2BoundedBufferActivity methodsFor: 'guards'!

guardOFget
	"As for superclass, except that we also have to exclude concurrent activity of get2.
	Note that the guard of get is maintained valid,
	thanks to the redefinition of virtual method numberOfElements."

	^super guardOFget
		and: [(self current: #get2) = 0]!

guardOFget2
	"Only one get or get2 at once and the buffer should contain at least two elements."

	^(self current: #get2) = 0
		and: [((self current: #get) = 0)
			and: [self numberOfElements >= 2]]!

numberOfElements
	"Number of elements currently in the buffer.
	We need to substract number of elements removed by get2 method (two elements for each completion)."

	^super numberOfElements - ((self completed: #get2) * 2)! !

BookUser subclass: #Reader
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
Reader comment:
'Class Reader simply defines its body to do numberSteps time reads. Random delays are used to simulate various interleavings between readers and writers.
Class Reader is defined as a subclass of abstract class BookUser.

This class has been initially designed and implemented in a previous version of Actalk by a group of students of DESS of University of Nantes, under the guidance of Jean Bezivin and Olivier Roux.'!


!Reader methodsFor: 'body'!

body
	"Body: do numberSteps times his life steps, that is: think and then read."
	"Note that this active object class has no script method as it receives no message."

	numberSteps timesRepeat: 
		[self think.
		Transcript show: self printString , ' wants to read ' , book printString; cr.
		(book readBy: aself) value]! !

BookActivity subclass: #WriterPriorityBookActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
WriterPriorityBookActivity comment:
'Class WriterPriorityBookActivity specifies priority to the writers, that is no read if there is a pending write.
Class WriterPriorityBookActivity is defined as a subclass of activity class BookActivity.'!


!WriterPriorityBookActivity methodsFor: 'guards'!

guardOFreadBy: reader
	"Priority to writers, that is no read if there is a pending write."

	^(super guardOFreadBy: reader)
		and: [(self pending: #writeBy:) = 0]! !

ImplicitReplyObject subclass: #Book
	instanceVariableNames: 'readers writers numberSteps '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
Book comment:
'Class Book implements the example of multiple readers and writers accessing a single book by using synchronization counters.
Classes of activity BookActivity, ReaderPriorityBookActivity, and WriterPriorityBookActivity provide variations on synchronization constraints.

This class has been initially designed and implemented in a previous version of Actalk by a group of students of DESS of University of Nantes, under the guidance of Jean Bezivin and Olivier Roux.'!


!Book methodsFor: 'initialize'!

makeReadersAndWriters
	"Create and activate readers and writers of the book."

	1 to: readers size do: [:i |
		readers at: i put:
			(Reader new number: i book: aself numberSteps: numberSteps) active].
	1 to: writers size do: [:i |
		writers at: i put:
			(Writer new number: i book: aself numberSteps: numberSteps) active]!

readers: nReaders writers: nWriters numberSteps: steps
	readers := Array new: nReaders.
	writers := Array new: nWriters.
	numberSteps := steps! !

!Book methodsFor: 'script'!

readBy: reader
	| delay |
	delay := (Random new next * 5) rounded + 1.
	Transcript show: reader printString , ' starts reading ' , self printString , ' during ' , delay printString , ' seconds.'; cr.
	(Delay forSeconds: delay) wait.
	Transcript show: reader printString , ' stopped reading ' , self printString; cr!

start
	self makeReadersAndWriters!

writeBy: writer
	| delay |
	delay := (Random new next * 5) rounded + 1.
	Transcript show: writer printString , ' starts writing ' , self printString , ' during ' , delay printString , ' seconds.'; cr.
	(Delay forSeconds: delay) wait.
	Transcript show: writer printString , ' stopped writing ' , self printString; cr! !

!Book methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity guards specification."

	^BookActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Book class
	instanceVariableNames: ''!


!Book class methodsFor: 'example'!

example
	"self example"

	(self new readers: 3 writers: 2 numberSteps: 3) active start!

readerPriorityExample
	"self readerPriorityExample"

	((self new readers: 3 writers: 2 numberSteps: 3)
		active: ReaderPriorityBookActivity) start!

writerPriorityExample
	"self writerPriorityExample"

	((self new readers: 3 writers: 2 numberSteps: 3)
		active: WriterPriorityBookActivity) start! !

CountersBoundedBufferActivity subclass: #CountersGetRearBoundedBufferActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
CountersGetRearBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!CountersGetRearBoundedBufferActivity methodsFor: 'guards'!

guardOFgetRear
	"Method getRear removes an element at rear and does not conflict with get removal at head.
	Meanwhile method getRear excludes itself as well as method put:.
	Moreover the buffer should have at least one more element than current number
	of activated get.
	Note that this leads to maximal concurrency:
	methods get and getRear may be active concurrently if the buffer has more than one element."

	^(self current: #getRear) = 0
		and: [((self current: #put:) = 0)
			and: [self numberOfElements > (self current: #get)]]!

guardOFput: item
	"As for superclass, except that we also have to exclude concurrent activity of getRear.
	Note that the guard of put: (and of get) is maintained valid,
	thanks to the redefinition of abstract method numberOfElements."

	^(super guardOFput: item)
		and: [(self current: #getRear) = 0]!

numberOfElements
	"Number of elements currently in the buffer.
	We need to substract number of elements removed by getRear method."

	^super numberOfElements - (self completed: #getRear)! !

ConcurrentBoundedBuffer subclass: #CountersBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Counters-Ex'!
CountersBoundedBuffer comment:
'Class CountersBoundedBuffer implements the example of the bounded buffer with guards on synchronization counters to specify synchronization on state and on invocation.
Guard specification is expressed within the associated activity class in order to enforce a clear separation between program and control.
Note that because guard specifications are quite modular, they behave quite well against inheritance anomaly.'!


!CountersBoundedBuffer methodsFor: 'accessing'!

maxSize
	^maxSize! !

!CountersBoundedBuffer methodsFor: 'default classes'!

activityClass
	"Synchronization is specified by the activity guards specification."

	^CountersBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CountersBoundedBuffer class
	instanceVariableNames: ''!


!CountersBoundedBuffer class methodsFor: 'example'!

exampleSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleSize: maxSize numberItems: numberItems speedRatio: ratio! !

