ImplicitReplyActivity subclass: #Guards1Activity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Guards'!
Guards1Activity comment:
'Class Guards1Activity implements a model of synchronization with guards.
It is defined as a subclass of activity class SelectiveAcceptActivity.
This means messages are resent if they are not acceptable. Acceptance is defined as the corresponding guard evaluationg to true.
Guards are easily defined as simple methods.

Note that because of resending messages whose guard evaluates to false, this initial implementation model of guards is somewhat costly, plus it does not preserve message ordering preservation.
See class GuardsActivity for a more sophisticated and optimized implementation.'!


!Guards1Activity methodsFor: 'message handling'!

isCandidateMessage: aMessage
	"First naive implementation of guards."
	"A message is candidate for acceptance if its asociated guard evaluates to true."

	"Note that because of resending message which are not candidate,
	it does not ensure message ordering preservation."

	^self evaluateGuardForMessage: aMessage!

nextMessage
	"Next message is first acceptable message.
	Resend other ones."

	| message |
	[message := super nextMessage.
	self isCandidateMessage: message] whileFalse:
		[address internalReceiveMessage: message].
	^message! !

!Guards1Activity methodsFor: 'guard testing'!

evaluateGuardForMessage: aMessage
	"Evaluate the associated condition/guard with the current arguments."

	^self perform: (self guardOfSelector: aMessage selector)
		withArguments: aMessage arguments!

guardOfSelector: selector
	"Return the selector (symbol) of the guard associated to a selector."
	"A guard is simply associated to a selector with the prefix guardOF.
	For instance the guard of method put: is the method guardOFput:."

	^('guardOF' , selector) asSymbol! !

ImplicitReplyObject subclass: #GuardsObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Guards'!
GuardsObject comment:
'Class GuardsObject is a class of active object behaviors. Its only purpose is to dispatch onto activity class GuardsActivity.
It is defined as a subclass of behavior class ImplicitReplyObject in order to achieve consistency with its associated activity class hierarchy. (Meanwhile it could have been as well defined as a subclass of ActiveObject).'!


!GuardsObject methodsFor: 'default classes'!

activityClass
	"Only purpose is to dispatch onto activity class GuardsActivity."

	^GuardsActivity! !

GuardsObject subclass: #ObjectGuardsObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Guards'!
ObjectGuardsObject comment:
'Class ObjectGuardsObject is a class of active object behaviors. Its only purpose is to dispatch onto activity class ObjectGuardsActivity.'!


!ObjectGuardsObject methodsFor: 'default classes'!

activityClass
	"Only purpose is to dispatch onto activity class ObjectGuardsActivity."

	^ObjectGuardsActivity! !

Guards1Activity subclass: #GuardsActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Guards'!
GuardsActivity comment:
'Class GuardsActivity implements a model of synchronization with guards.
It is defined as a subclass of activity class Guards1Activity.
Class GuardsActivity implements a more sophisticated and optimized implementation which does not resend messages. Thus it enforces message ordering preservation.'!


!GuardsActivity methodsFor: 'message handling'!

nextMessage
	"Look for the first message in the mailbox verifying its guard.
	If all current pending messages have false guards,
	then suspend until next received message and check its guard, etc...
	This makes use of method atIndex: which suspends until there is a ith message in the mailBox."

	"As opposed to the initial naive strategy of resending the message
	(class Guards1Activity), this strategy is more efficient
	and it also ensures message ordering preservation."

	"About guards reevaluation semantics:
	Guards are reevaluated (only) when looking for a new message to accept.
	There is no intra-object concurrency in this model of guards."

	| i message mailBox |
	mailBox := self mailBox.
	i := 1.
	message := mailBox atIndex: i.
	[self isCandidateMessage: message] whileFalse:
		[i := i+1.
		message := mailBox atIndex: i].
	mailBox removeAtIndex: i.
	^message! !

GuardsActivity subclass: #ObjectGuardsActivity
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-Guards'!
ObjectGuardsActivity comment:
'Class ObjectGuardsActivity is defined as a facility to delegate guard specification to the behavior of the active object.
It is defined as a subclass of activity class GuardsActivity.'!


!ObjectGuardsActivity methodsFor: 'guard testing'!

evaluateGuardForMessage: aMessage
	"Delegate the specification and evaluation of the guards to the behavior."

	^bself perform: (self guardOfSelector: aMessage selector)
		withArguments: aMessage arguments! !

