CurrentMessageActivity subclass: #OCoreBoundedBufferActivity
	instanceVariableNames: 'getQueue putQueue '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-OCore-Ex'!
OCoreBoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!OCoreBoundedBufferActivity methodsFor: 'initialize'!

initialize
	getQueue := OrderedCollection new.
	putQueue := OrderedCollection new! !

!OCoreBoundedBufferActivity methodsFor: 'event handlers'!

bufferEmptyEvent
	getQueue add: currentMessage!

bufferFullEvent
	putQueue add: currentMessage! !

!OCoreBoundedBufferActivity methodsFor: 'events'!

kernelEventComplete: aMessage
	"Compute one suspended request if condition is fullfilled."

	super kernelEventComplete: aMessage.
	(putQueue isEmpty not and: [bself isFull not])
		ifTrue:
			[self acceptMessage: putQueue removeFirst]
		ifFalse:
			[(getQueue isEmpty not and: [bself isEmpty not])
				ifTrue:
					[self acceptMessage: getQueue removeFirst]]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

OCoreBoundedBufferActivity class
	instanceVariableNames: ''!


!OCoreBoundedBufferActivity class methodsFor: 'instance creation'!

new
	^super new initialize! !

OCoreBoundedBufferActivity subclass: #OCoreGet2BoundedBufferActivity
	instanceVariableNames: 'get2Queue '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-OCore-Ex'!
OCoreGet2BoundedBufferActivity comment:
'This activity class specifies the synchronization of its associated behavior class.'!


!OCoreGet2BoundedBufferActivity methodsFor: 'initialize'!

initialize
	super initialize.
	get2Queue := OrderedCollection new! !

!OCoreGet2BoundedBufferActivity methodsFor: 'event handlers'!

suspendGet2Event
	get2Queue add: currentMessage! !

!OCoreGet2BoundedBufferActivity methodsFor: 'events'!

kernelEventComplete: aMessage
	"Compute one suspended request if condition is fullfilled."
	"May resume a suspended get2 after resuming a suspended get.
	But the problem of fairness between get and get2 requests is not very well handled."

	super kernelEventComplete: aMessage.
	(get2Queue isEmpty not and: [bself hasAtLeastTwoElements])
		ifTrue: [self acceptMessage: get2Queue removeFirst]! !

BoundedBuffer subclass: #OCoreBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-OCore-Ex'!
OCoreBoundedBuffer comment:
'Class OCoreBoundedBuffer implements the bounded buffer with synchronization expressed in terms of user-defined events at meta-level. This implementation follows the description given in the paper Meta-level Architecture in OCore, which was presented at the OOPSLA''93 Reflection Workshop by Takashi Tomokiyo et al.

Activity class CurrentMessageActivity partially implements meta-level architecture of OCore. Actually Actalk events methods already provide much of OCore user-events facilities.

Two message queues are defined in order to store failed requests (put requests if buffer is full, get requests if buffer is empty). Pseudo-variable currentMessage reference is necessary to reference failed message and enqueue it. After completion of a message, one of the message queues containing waiting requests is rechecked for acceptance.

Note that this specification is rather low-level and not separated from the code. It is not very good at solving inheritance anomaly.'!


!OCoreBoundedBuffer methodsFor: 'script'!

getAndReplyTo: r
	"If empty, then invoke the buffer empty user-defined event handler."

	self isEmpty
		ifTrue:
			[self activity bufferEmptyEvent]
		ifFalse:
			[super getAndReplyTo: r]!

put: item
	"If full, then invoke the buffer full user-defined event handler."

	self isFull
		ifTrue:
			[self activity bufferFullEvent]
		ifFalse:
			[super put: item]! !

!OCoreBoundedBuffer methodsFor: 'default classes'!

activityClass
	"OCore-based associated activity."

	^OCoreBoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

OCoreBoundedBuffer class
	instanceVariableNames: ''!


!OCoreBoundedBuffer class methodsFor: 'example'!

exampleSize: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleSize: 3 numberItems: 8 speedRatio: 3"
	"self exampleSize: 3 numberItems: 8 speedRatio: 1/3"

	super exampleSize: maxSize numberItems: numberItems speedRatio: ratio! !

OCoreBoundedBuffer subclass: #OCoreGgetBoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-OCore-Ex'!
OCoreGgetBoundedBuffer comment:
'This class implements an example of inheritance anomaly.'!


!OCoreGgetBoundedBuffer methodsFor: 'script'!

ggetAndReplyTo: r
	"Too complex to handle because when a method fails and invokes user-defined event handlers the event complete is still activated.
	This makes management of afterPut flag to be very difficult because it may be shadowed by the
	aborted gget and also by a put resumed..."! !

OCoreBoundedBuffer subclass: #OCoreGet2BoundedBuffer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Actalk-Synchro-OCore-Ex'!
OCoreGet2BoundedBuffer comment:
'This class implements an example of inheritance anomaly.'!


!OCoreGet2BoundedBuffer methodsFor: 'script'!

get2AndReplyTo: r
	"If less than two elements, then invoke the suspendGet2 user-defined event handler."

	self hasAtLeastTwoElements not
		ifTrue:
			[self activity suspendGet2Event]
		ifFalse:
			[r reply: (Array
						with: contents removeFirst
						with: contents removeFirst)]! !

!OCoreGet2BoundedBuffer methodsFor: 'state predicates'!

hasAtLeastTwoElements
	^contents size >= 2! !

!OCoreGet2BoundedBuffer methodsFor: 'default classes'!

activityClass
	"OCore-based associated activity."

	^OCoreGet2BoundedBufferActivity! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

OCoreGet2BoundedBuffer class
	instanceVariableNames: ''!


!OCoreGet2BoundedBuffer class methodsFor: 'example'!

exampleGet2Size: maxSize numberItems: numberItems speedRatio: ratio
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 3"
	"self exampleGet2Size: 3 numberItems: 8 speedRatio: 1/3"

	| buffer producer consumer |
	buffer := (self new: maxSize) active.
	producer := (Producer new buffer: buffer delay: 1) active.
	consumer := (Consumer new buffer: buffer delay: ratio) active.
	producer runPut: numberItems.
	consumer runGet2: numberItems replyTo: Print! !

