'From Objectworks\Smalltalk(R), Release 4.1 of 15 April 1992 on 14 May 1994 at 2:30:43 pm'!



!ClassDescription methodsFor: 'selectors'!

allSelectorsInCategory: aCategoryName untilClass: aClass
	"Answer a set of all the message selectors belonging to a category within a subhierarchy,
	that is from receiver until (including) the class specified."
	"The class boundary allowes to restrict the search to some subhierarchy, e.g., of Actalk."

	"We stop when reaching one hierarchy root."
	^((self == aClass) | (superclass isNil)
			ifTrue: [Set new]
			ifFalse: [superclass allSelectorsInCategory: aCategoryName untilClass: aClass])
		addAll: (self selectorsInCategory: aCategoryName);
	"Return the constructed set because addAll: returns the addition only."
		yourself!

selectorsInCategory: aCategoryName
	"Answer a set of all the message selectors belonging to a category of the receiver."

	^self organization listAtCategoryNamed: aCategoryName! !