'From Objectworks\Smalltalk(R), Release 4.1 of 15 April 1992 on 14 May 1994 at 2:27:01 pm'!



!ProcessorScheduler class methodsFor: 'slc'!

example
	"self stopTimeSlicing.
	 self example inspect"

	"self startTimeSlicingEvery: 5.
	 self example inspect"

	"Please see comments below the code."

	| queue |
	queue := SharedQueue new.
	[100 timesRepeat: [queue nextPut: 1]] fork.
	[100 timesRepeat: [queue nextPut: 2]] fork.
	^queue

	"SharedTextCollector setProtectedTranscript"

	"The expression above should be evaluated in order to set a new protected transcript
	when using any time-slicing scheduler facility.
	Note that you then need to open a new transcript because current one becomes out of date."

	"Copyright notice and acknowledgements to the author of this goodie is located below."

"This time-slicing facility is slightly adapted from the timeslice Smalltalk Goodie
author: huba@ls5.informatik.uni-dortmund.de (Hubert Baumeister)
version: 1
date: 13 March 1991

A short example of how time slicing could be done.
The basics is a high priority process that wakes up every few milliseconds
and regroups the processes in the waiting queue of the highest priority
that has more than one process.

To see how it works evaluate first

	self stopTimeSlicing. 
	self example inspect

In the contents of queue you will find first all the 1's and then all the 2's.

If you then evaluate

	self startTimeSlicingEvery: 5. 
	self example inspect

then the 1's and 2's are mixed.

But notice that time slicing is dangerous in the current implementation of the
Smalltalk user interface as shows following example:

	ProcessorScheduler startTimeSlicing. 
	[100 timesRepeat: [Transcript show: 'Process 1';cr]] fork.
	[100 timesRepeat: [Transcript show: 'Process 2';cr]] fork

This will hang up Smalltalk because some recources are not protected against multiple access.
(This is why the example above uses a SharedQueue instead of a WriteStream)

---Warning---
The above file is a Manchester Goodie.  It is distributed freely on condition
that you observe these conditions in respect of the whole Goodie, and on
any significant part of it which is separately transmitted or stored:
	* You must ensure that every copy includes this notice, and that
	source and author(s) of the material are acknowledged.
	* These conditions must be imposed on anyone who receives a copy.
	* The material shall not be used for commercial gain without the prior
	written consent of the author(s).

For more information about the Manchester Goodies Library
(from which this file was distributed) send e-mail:
	To: goodies-lib@cs.man.ac.uk
	Subject: help
"!

startTimeSlicingEvery: sliceTimeInMilliseconds
	"self startTimeSlicingEvery: 5"

	TimeSliceProcess notNil
		ifTrue: [^self].
	TimeSliceProcess :=
		[[true] whileTrue:
			[(Delay forMilliseconds: sliceTimeInMilliseconds) wait. Processor slice]] newProcess.
	TimeSliceProcess priority: (Processor highestPriority).
	TimeSliceProcess resume!

stopTimeSlicing
	"self stopTimeSlicing"

	TimeSliceProcess notNil
		ifTrue:
			[TimeSliceProcess terminate.
			TimeSliceProcess := nil]! !