'From Objectworks\Smalltalk(R), Release 4.1 of 15 April 1992 on 14 May 1994 at 2:28:11 pm'!

TextCollector subclass: #SharedTextCollector
	instanceVariableNames: 'accessProtect '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Interface-Text'!
SharedTextCollector comment:
'Class SharedTextCollector implements a TextCollector (Transcript window) protected against concurrent accesses which may happen when using time-slicing scheduling facilities.

Protection is ensured by the accessProtect mutual exclusion semaphore.

Please note that we actually only protect (redefine) methods show: and cr (which are the most commonly used). A more systematic protection would have to act on accesses to the internal entryStream.

A new protected transcript is installed by method setProtectedTranscript (although you need to open a new transcript, see method comment).'!


!SharedTextCollector methodsFor: 'initialize'!

initialize
	super initialize.
	accessProtect := Semaphore forMutualExclusion! !

!SharedTextCollector methodsFor: 'accessing'!

cr
	"Append a carriage return to the text."
	"Protected version."

	^[accessProtect critical:
		[super cr]] valueUnpreemptively!

show: aString
	"Append all the characters in aCollection to the text and display the text."
	"Protected version."

	[accessProtect critical:
		[super show: aString]] valueUnpreemptively! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SharedTextCollector class
	instanceVariableNames: ''!


!SharedTextCollector class methodsFor: 'initialize'!

setProtectedTranscript
	"SharedTextCollector setProtectedTranscript"

	"The expression above should be evaluated in order to set a new protected transcript
	when using any time-slicing scheduler facility.
	Note that you then need to open a new transcript because current one becomes out of date."

	TextCollector newTranscript: SharedTextCollector new! !